primitive U_L_SB_RB_NO_Q ( Q, SB, RB, NOTIFY_REG);
output Q;	reg Q;
input SB, RB, NOTIFY_REG;

// FUNCTION : CROSS-COUPLED NAND LATCH.  SET AND RESET ARE ACTIVE LOW.  SET IS
//            DOMINANT ( Q OUTPUT UDP ).

//  This model does not reflect the data ambiguity when set and
//  reset are both active and simultaneously change to inactive.

table
  //    SB      RB      NO  :   Qt  :   Qt+1                                   
                                
        (?0)    ?       ?   :   ?   :   1   ;   // normal set case
        (?1)    0       ?   :   ?   :   0   ;   // ignore posedge when RB active

        1       (?0)    ?   :   ?   :   0   ;   // normal reset case
        0       *       ?   :   ?   :   1   ;   // ignore edges when SB sctive

        (?x)    ?       ?   :   1   :   -   ;   // reducing pessimism
        (?1)    1       ?   :   1   :   -   ;
        1       (?x)    ?   :   0   :   -   ;
        1       (?1)    ?   :   0   :   -   ;
        
        ?       ?       *   :   ?   :   x   ;   // notifier case

endtable
endprimitive

